--
-- AdditionalPlaceableTypes
-- Class to load additional placeable types from modDesc xml
--
-- @author  Stefan Maurus
-- @date  03/06/2020
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

local modName = g_currentModName
local modDir = g_currentModDirectory
local sourceDir = modDir

local function load()
    local _, _, isDlc, _ = Utils.removeModDirectory(modDir)
    local filename = modDir .. "modDesc.xml"
    if isDlc then
        filename = modDir .. "dlcDesc.xml"
    end

    local xmlFile = loadXMLFile("ModFile", filename)

    local i = 0
    while true do
        local key = string.format("modDesc.placeableTypes.placeableType(%d)", i)
        if not hasXMLProperty(xmlFile, key) then
            break
        end

        local typeName = getXMLString(xmlFile, key.. "#name")
        if typeName == nil then
            break
        end
        local className = getXMLString(xmlFile, key.. "#className")

        if GS_IS_CONSOLE_VERSION then
            sourceDir = "dataS/scripts/internalMods/"..modName.."/"
        end
        local typeFilename =  Utils.getFilename(getXMLString(xmlFile, key.. "#filename"), sourceDir)

        g_placeableTypeManager:addPlaceableType(typeName, modName .. "." .. className, typeFilename, modName)

        i = i + 1
    end

    delete(xmlFile)
end

local function validateVehicleTypes()
    if g_modIsLoaded[modName] then
        load()
    end
end
VehicleTypeManager.validateVehicleTypes = Utils.prependedFunction(VehicleTypeManager.validateVehicleTypes, validateVehicleTypes)
