--
-- AdditionalSpecializations
-- Load additional specializations to existing ones, so we don't have issues with renamed vehicleTypes for AI
--
-- @author  Stefan Maurus
-- @date  01/07/2019
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

local modName = g_currentModName

local additionals = {
}

local additionalsSpec = {
    sprayer = {
        modName .. ".extendedSprayer"
    },
    sowingMachine = {
        modName .. ".extendedSowingMachine"
    },
    motorized = {
        modName .. ".extendedMotorized"
    },
    wearable = {
        modName .. ".extendedWearable"
    },
    aiVehicle = {
        modName .. ".extendedAIVehicle"
    },
    combine = {
        modName .. ".extendedCombine"
    },
    mower = {
        modName .. ".extendedMower"
    }
}

local globalSpec = {
    modName .. ".precisionFarmingStatistic"
}

local oldFinalizeVehicleTypes = VehicleTypeManager.finalizeVehicleTypes
VehicleTypeManager.finalizeVehicleTypes = function(self, ...)
    if g_modIsLoaded[modName] then
        for typeName, typeEntry in pairs(self:getVehicleTypes()) do
            for _, spec in pairs(globalSpec) do
                if typeEntry.specializationsByName[spec] == nil then
                    self:addSpecialization(typeName, spec)
                end
            end

            for name, spec in pairs(typeEntry.specializationsByName) do
                for addName, specs in pairs(additionalsSpec) do
                    if name == addName then
                        for i=1, #specs do
                            if typeEntry.specializationsByName[specs[i]] == nil then
                                self:addSpecialization(typeName, specs[i])
                            end
                        end
                    end
                end
            end

            for name, specs in pairs(additionals) do
                if typeName == name then
                    for i=1, #specs do
                        if typeEntry.specializationsByName[specs[i]] == nil then
                            self:addSpecialization(typeName, specs[i])
                        end
                    end
                end
            end
        end
    end

    oldFinalizeVehicleTypes(self, ...)
end
