---
-- Charging station placeable
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

RTKStation = {}
local RTKStation_mt = Class(RTKStation, Placeable)

InitObjectClass(RTKStation, "RTKStation")

function RTKStation:new(isServer, isClient, customMt)
    local self = Placeable:new(isServer, isClient, customMt or RTKStation_mt)

    registerObjectClassName(self, "RTKStation")

    return self
end

---Deleting placeable
-- @includeCode
function RTKStation:delete()
    if g_precisionFarming ~= nil then
        g_precisionFarming.aiExtension:unregisterRTKStation(self)
    end

    RTKStation:superClass().delete(self)
end

---Load placeable
-- @param string xmlFilename xml file name
-- @param float x x world position
-- @param float y z world position
-- @param float z z world position
-- @param float rx rx world rotation
-- @param float ry ry world rotation
-- @param float rz rz world rotation
-- @param boolean initRandom initialize random
-- @return boolean success success
-- @includeCode
function RTKStation:finalizePlacement()
    if g_precisionFarming ~= nil then
        g_precisionFarming.aiExtension:registerRTKStation(self)
    end

    RTKStation:superClass().finalizePlacement(self)
end
