-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

RequestFarmlandStatisticsEvent = {}
---Event for syncing the farmland stats to the player
-- @category Events

local RequestFarmlandStatisticsEvent_mt = Class(RequestFarmlandStatisticsEvent, Event)

InitEventClass(RequestFarmlandStatisticsEvent, "RequestFarmlandStatisticsEvent")

---Create instance of Event class
-- @return table self instance of class event
-- @includeCode
function RequestFarmlandStatisticsEvent:emptyNew()
    local self = Event:new(RequestFarmlandStatisticsEvent_mt)
    return self
end

---Create new instance of event
-- @param table object object
-- @includeCode
function RequestFarmlandStatisticsEvent:new(farmlandId)
    local self = RequestFarmlandStatisticsEvent:emptyNew()
    self.farmlandId = farmlandId
    return self
end

---Called on client side on join
-- @param integer streamId streamId
-- @param integer connection connection
-- @includeCode
function RequestFarmlandStatisticsEvent:readStream(streamId, connection)
    self.farmlandId = streamReadUIntN(streamId, 8)
    self:run(connection)
end

---Called on server side on join
-- @param integer streamId streamId
-- @param integer connection connection
-- @includeCode
function RequestFarmlandStatisticsEvent:writeStream(streamId, connection)
    streamWriteUIntN(streamId, self.farmlandId, 8)
end

---Run action on receiving side
-- @param integer connection connection
-- @includeCode
function RequestFarmlandStatisticsEvent:run(connection)
    if not connection:getIsServer() then
        g_server:broadcastEvent(FarmlandStatisticsEvent:new(self.farmlandId), false, nil, nil, true, {connection})
    end
end
