-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

ResetYieldMapEvent = {}
---Event for syncing the farmland stats to the player
-- @category Events

local ResetYieldMapEvent_mt = Class(ResetYieldMapEvent, Event)

InitEventClass(ResetYieldMapEvent, "ResetYieldMapEvent")

---Create instance of Event class
-- @return table self instance of class event
-- @includeCode
function ResetYieldMapEvent:emptyNew()
    local self = Event:new(ResetYieldMapEvent_mt)
    return self
end

---Create new instance of event
-- @param table object object
-- @includeCode
function ResetYieldMapEvent:new(farmlandId)
    local self = ResetYieldMapEvent:emptyNew()
    self.farmlandId = farmlandId
    return self
end

---Called on client side on join
-- @param integer streamId streamId
-- @param integer connection connection
-- @includeCode
function ResetYieldMapEvent:readStream(streamId, connection)
    self.farmlandId = streamReadUIntN(streamId, 8)
    self:run(connection)
end

---Called on server side on join
-- @param integer streamId streamId
-- @param integer connection connection
-- @includeCode
function ResetYieldMapEvent:writeStream(streamId, connection)
    streamWriteUIntN(streamId, self.farmlandId, 8)
end

---Run action on receiving side
-- @param integer connection connection
-- @includeCode
function ResetYieldMapEvent:run(connection)
    if not connection:getIsServer() then
        if g_precisionFarming ~= nil then
            if g_precisionFarming.yieldMap ~= nil then
                g_precisionFarming.yieldMap:resetFarmlandYieldArea(self.farmlandId)
                g_precisionFarming:updatePrecisionFarmingOverlays()
            end
        end
    end
end
