--
-- ConnectionHoseConfigurations
--
-- @author  Stefan Maurus
-- @date  02/09/2020
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

---Specialization to add configurations for connection hose targets
-- @category Specializations
ConnectionHoseConfigurations = {}

---Checks if all prerequisite specializations are loaded
-- @param table specializations specializations
-- @return boolean hasPrerequisite true if all prerequisite specializations are loaded
-- @includeCode
function ConnectionHoseConfigurations.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(ConnectionHoses, specializations)
end

function ConnectionHoseConfigurations.registerFunctions(vehicleType)
end

function ConnectionHoseConfigurations.registerOverwrittenFunctions(vehicleType)
end

function ConnectionHoseConfigurations.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType, "onLoad", ConnectionHoseConfigurations)
end

---
-- @includeCode
function ConnectionHoseConfigurations.initSpecialization()
    g_configurationManager:addConfigurationType("connectionHose", g_i18n:getText("configuration_design"), "connectionHoses", nil, nil, nil, ConfigurationUtil.SELECTOR_MULTIOPTION)
end

function ConnectionHoseConfigurations:onLoad(savegame)
    local configurationId = Utils.getNoNil(self.configurations["connectionHose"], 1)
    local configKey = string.format("vehicle.connectionHoses.connectionHoseConfigurations.connectionHoseConfiguration(%d)", configurationId - 1)
    ObjectChangeUtil.updateObjectChanges(self.xmlFile, "vehicle.connectionHose.connectionHoseConfigurations.connectionHoseConfiguration", configurationId , self.components, self)

    if hasXMLProperty(self.xmlFile, configKey) then
        local spec = self.spec_connectionHoses

        self:addHoseTargetNodes(self.xmlFile, configKey .. ".target")

        if #spec.targetNodes > 0 then
            spec.targetNodesAvailable = true
        end
    end
end
