--
-- ExtendedAIVehicle
--
-- @author  Stefan Maurus
-- @date  21/10/2020
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

---Specialization to track ai helper costs
-- @category Specializations
ExtendedAIVehicle = {}

ExtendedAIVehicle.MOD_NAME = g_currentModName

---Checks if all prerequisite specializations are loaded
-- @param table specializations specializations
-- @return boolean hasPrerequisite true if all prerequisite specializations are loaded
-- @includeCode
function ExtendedAIVehicle.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(AIVehicle, specializations) and SpecializationUtil.hasSpecialization(PrecisionFarmingStatistic, specializations)
end

function ExtendedAIVehicle.registerFunctions(vehicleType)
end

function ExtendedAIVehicle.registerOverwrittenFunctions(vehicleType)
    SpecializationUtil.registerOverwrittenFunction(vehicleType, "updateAILowFrequency", ExtendedAIVehicle.updateAILowFrequency)
end

function ExtendedAIVehicle.registerEventListeners(vehicleType)
end

---
-- @includeCode
function ExtendedAIVehicle:updateAILowFrequency(superFunc, dt)
    local spec = self.spec_aiVehicle

    if self:getIsAIActive() then
        local difficultyMultiplier = g_currentMission.missionInfo.buyPriceMultiplier;
        local price = -dt * difficultyMultiplier * spec.pricePerMS

        -- If field was not owned, it is a mission. Increase the price for balancing.
        if self.getLastTouchedFarmlandFarmId ~= nil and self:getLastTouchedFarmlandFarmId() == 0 then
            price = price * MissionManager.AI_PRICE_MULTIPLIER
        end

        local farmlandStatistics, _, farmlandId = self:getPAStatisticInfo()
        if farmlandStatistics ~= nil then
            if farmlandId ~= nil then
                farmlandStatistics:updateStatistic(farmlandId, "helperCosts", -price)
            end
        end
    end

    superFunc(self, dt)
end
