--
-- ExtendedCombine
--
-- @author  Stefan Maurus
-- @date  23/10/2020
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

---Specialization to toggle minimap zoom while on field
-- @category Specializations
ExtendedCombine = {}
ExtendedCombine.MOD_NAME = g_currentModName

---Checks if all prerequisite specializations are loaded
-- @param table specializations specializations
-- @return boolean hasPrerequisite true if all prerequisite specializations are loaded
-- @includeCode
function ExtendedCombine.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Combine, specializations)
       and SpecializationUtil.hasSpecialization(PrecisionFarmingStatistic, specializations)
end

function ExtendedCombine.registerFunctions(vehicleType)
end

function ExtendedCombine.registerOverwrittenFunctions(vehicleType)
end

function ExtendedCombine.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType, "onUpdateTick", ExtendedCombine)
    SpecializationUtil.registerEventListener(vehicleType, "onRegisterActionEvents", ExtendedCombine)
end

---
-- @includeCode
function ExtendedCombine:onUpdateTick(dt, isActiveForInput, isActiveForInputIgnoreSelection, isSelected)
    if self.isClient then
        if self:getIsActiveForInput(true, true) then
            ExtendedCombine.updateMinimapActiveState(self)
        end
    end
end

---
-- @includeCode
function ExtendedCombine:onRegisterActionEvents(isActiveForInput, isActiveForInputIgnoreSelection)
    if self.isClient then
        if isActiveForInputIgnoreSelection then
            ExtendedCombine.updateMinimapActiveState(self)
        else
            ExtendedCombine.updateMinimapActiveState(self, false)
        end
    end
end

---
-- @includeCode
function ExtendedCombine.updateMinimapActiveState(self, forcedState)
    local yieldMap = self:getPAYieldMap()

    local isActive = forcedState
    if isActive == nil then
        local _, _, _, isOnField, mission = self:getPAStatisticInfo()
        isActive = isOnField and self.spec_combine.numAttachedCutters > 0 and mission == nil
    end

    yieldMap:setRequireMinimapDisplay(isActive, self, self:getIsSelected())
end
