--[[
Interface: 1.5.1.0 b6732

Copyright (C) GtX (Andy), 2019

Author: GtX | Andy
Date: 24.03.2019
Version: 1.0.0.0

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

History:
V 1.0.0.0 @ 24.03.2019 - Release Version

Important:
No changes are to be made to this script without permission from GtX | Andy
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


WeighStationPlaceable = {}

local WeighStationPlaceable_mt = Class(WeighStationPlaceable, Placeable)
InitObjectClass(WeighStationPlaceable, "WeighStationPlaceable")

function WeighStationPlaceable:new(isServer, isClient, customMt)
    local self = Placeable:new(isServer, isClient, customMt or WeighStationPlaceable_mt)

    registerObjectClassName(self, "WeighStationPlaceable")

    self.weighStation = nil

    return self
end

function WeighStationPlaceable:load(xmlFilename, x,y,z, rx,ry,rz, initRandom)
    if not WeighStationPlaceable:superClass().load(self, xmlFilename, x,y,z, rx,ry,rz, initRandom) then
        return false
    end

    if EnhancedWeighStation == nil then
        g_logManager:xmlWarning(xmlFilename, "'EnhancedWeighStation.lua' is not available and is required for this placeable script to operate!")
        return false
    end

    local key = "placeable.enhancedWeighStation"
    local xmlFile = loadXMLFile("TempXML", xmlFilename)

    local objectTrigger = I3DUtil.indexToObject(self.nodeId, getXMLString(xmlFile, key .. "#triggerNode"))
    if objectTrigger ~= nil then

        local displays, lights = {}, nil

        local i = 0
        while true do
            local displayKey = string.format(key .. ".displays.display(%d)", i)
            if not hasXMLProperty(xmlFile, displayKey) then
                break
            end

            local node = I3DUtil.indexToObject(self.nodeId, getXMLString(xmlFile, displayKey .. "#node"))
            if node ~= nil then
                local useImperial = Utils.getNoNil(getXMLBool(xmlFile, displayKey .. "#useImperial"), false)
                local showZero = Utils.getNoNil(getXMLBool(xmlFile, displayKey .. "#showZero"), true)

                table.insert(displays, {node = node, useImperial = useImperial, showZero = showZero})
            end

            i = i + 1
        end

        i = 0
        while true do
            local lightKey = string.format(key .. ".lights.light(%d)", i)
            if not hasXMLProperty(xmlFile, lightKey) then
                break
            end

            local node = I3DUtil.indexToObject(self.nodeId, getXMLString(xmlFile, lightKey .. "#node"))
            if node ~= nil then
                if lights == nil then
                    lights = {}
                end

                local isStopLight = Utils.getNoNil(getXMLBool(xmlFile, lightKey .. "#isStopLight"), true)
                local intensity = getXMLFloat(xmlFile, lightKey .. "#intensity")

                if intensity ~= nil and getHasShaderParameter(node, "lightControl") then
                    local _, y, z, w = getShaderParameter(node, "lightControl")
                    if isStopLight then
                        setShaderParameter(node, "lightControl", 0, y, z, w, false)
                    else
                        setShaderParameter(node, "lightControl", intensity, y, z, w, false)
                    end
                else
                    setVisibility(node, not isStopLight)
                end

                table.insert(lights, {node = node, isStopLight = isStopLight, intensity = intensity})
            end

            i = i + 1
        end

        self.weighStation = EnhancedWeighStation:new()
        self.weighStation:load(objectTrigger, true, displays, lights)
    else
        g_logManager:xmlWarning(xmlFilename, "No 'objectTrigger' was found!")
        return false
    end

    delete(xmlFile)
    xmlFile = nil

    return true
end

function WeighStationPlaceable:finalizePlacement()
    WeighStationPlaceable:superClass().finalizePlacement(self)

    if self.weighStation ~= nil then
        addTrigger(self.weighStation.triggerId, "triggerCallback", self.weighStation)
    end
end

function WeighStationPlaceable:delete()
    if self.weighStation ~= nil then
        self.weighStation:delete()
        self.weighStation = nil
    end

    unregisterObjectClassName(self)
    WeighStationPlaceable:superClass().delete(self)
end
