-- SurfDuck-Modding --

AnimationPartEDW = {};

function AnimationPartEDW.prerequisitesPresent(specializations)
      return true;
end;
function AnimationPartEDW.initSpecialization()
end
function AnimationPartEDW.registerOverwrittenFunctions(vehicleType)
end
function AnimationPartEDW.registerFunctions(vehicleType)	
end
function AnimationPartEDW.registerEvents(vehicleType)
end
function AnimationPartEDW:registerActionEventsPlayer()
end
function AnimationPartEDW:registerActionEventsMenu()
end

function AnimationPartEDW:onRegisterActionEvents(isSelected, isOnActiveVehicle)
	if isOnActiveVehicle then
		if self.AnimationPartEDW == nil then 
			self.AnimationPartEDW = {}
		else	
			self:clearActionEventsTable( self.AnimationPartEDW )
		end 
		for _,actionName in pairs({"panel_back","panel_left","panel_right"}) do
			local _, eventName = self:addActionEvent(self.AnimationPartEDW, InputAction[actionName], self, AnimationPartEDW.actionCallback, true, true, false, true, nil);
	
			if isSelected then
				g_inputBinding.events[eventName].displayPriority = 1
			end
		end
	end
end

function AnimationPartEDW.registerEventListeners(vehicleType)
	SpecializationUtil.registerEventListener(vehicleType, "onLoad", AnimationPartEDW)
	SpecializationUtil.registerEventListener(vehicleType, "onDelete", AnimationPartEDW)
    SpecializationUtil.registerEventListener(vehicleType, "onReadStream", AnimationPartEDW)
    SpecializationUtil.registerEventListener(vehicleType, "onWriteStream", AnimationPartEDW)
    --SpecializationUtil.registerEventListener(vehicleType, "onReadUpdateStream", AnimationPartEDW)
    --SpecializationUtil.registerEventListener(vehicleType, "onWriteUpdateStream", AnimationPartEDW)
	SpecializationUtil.registerEventListener(vehicleType, "onUpdate", AnimationPartEDW)
	SpecializationUtil.registerEventListener(vehicleType, "onDeactivate", AnimationPartEDW)
	SpecializationUtil.registerEventListener(vehicleType, "onDraw", AnimationPartEDW)
	SpecializationUtil.registerEventListener(vehicleType, "onRegisterActionEvents", AnimationPartEDW)
end

function AnimationPartEDW:onLoad(vehicle)	
	self.panel_back = AnimationPartEDW.panel_back
	self.panel_left = AnimationPartEDW.panel_left
	self.panel_right = AnimationPartEDW.panel_right
	self.Panel_Back = false
	self.Panel_Left = false
	self.Panel_Right = false
	
end;

function AnimationPartEDW:onDelete() 
end;
function AnimationPartEDW:onReadStream(streamId, connection)   
end;  
function AnimationPartEDW:onWriteStream(streamId, connection)  
end;
function AnimationPartEDW:mouseEvent(posX, posY, isDown, isUp, button)
end;
function AnimationPartEDW:keyEvent(unicode, sym, modifier, isDown)    
end;
function AnimationPartEDW:onUpdate(dt, vehicle)		
end;
function AnimationPartEDW:onUpdateTick() 
end;	
function AnimationPartEDW:onDeactivate()	
end;       
function AnimationPartEDW:onDraw()  
end;

function AnimationPartEDW:actionCallback(actionName, keyStatus, arg4, arg5, arg6)
	if keyStatus > 0 then
		if actionName == 'panel_back' then
			if self.Panel_Back then
				self:panel_back(false)
			else 
				self:panel_back(true)
			end
		end
		if actionName == 'panel_left' then
			if self.Panel_Left then
				self:panel_left(false)
			else 
				self:panel_left(true)
			end
		end
		if actionName == 'panel_right' then
			if self.Panel_Right then
				self:panel_right(false)
			else 
				self:panel_right(true)
			end
		end
	end
end

function AnimationPartEDW:panel_back(Panel_Back, noEventSend)
	panel_backEvent.sendEvent(self, Panel_Back, noEventSend)
	self.Panel_Back = Panel_Back;
		if self.Panel_Back then
			for name,_ in pairs(self.spec_animatedVehicle.animations) do
				self:playAnimation("panel_back", 1, nil, true)
			end
		else
			for name,_ in pairs(self.spec_animatedVehicle.animations) do
				self:playAnimation("panel_back", -1, nil, true)
			end
		end;
end;


function AnimationPartEDW:panel_left(Panel_Left, noEventSend)
	panel_leftEvent.sendEvent(self, Panel_Left, noEventSend)
	self.Panel_Left = Panel_Left;
		if self.Panel_Left then
			for name,_ in pairs(self.spec_animatedVehicle.animations) do
				self:playAnimation("panel_left", 1, nil, true)
			end
		else
			for name,_ in pairs(self.spec_animatedVehicle.animations) do
				self:playAnimation("panel_left", -1, nil, true)
			end
		end;
end;

function AnimationPartEDW:panel_right(Panel_Right, noEventSend)
	panel_rightEvent.sendEvent(self, Panel_Right, noEventSend)
	self.Panel_Right = Panel_Right;
		if self.Panel_Right then
			for name,_ in pairs(self.spec_animatedVehicle.animations) do
				self:playAnimation("panel_right", 1, nil, true)
			end
		else
			for name,_ in pairs(self.spec_animatedVehicle.animations) do
				self:playAnimation("panel_right", -1, nil, true)
			end
		end;
end;

--- Event ---

panel_backEvent = {};
panel_backEvent_mt = Class(panel_backEvent, Event);
InitEventClass(panel_backEvent, "panel_backEvent");

function panel_backEvent:emptyNew()
    local self = Event:new(panel_backEvent_mt);
    return self;
end;
function panel_backEvent:new(object, Panel_Back)
	local self = panel_backEvent:emptyNew()
	self.object = object;
	self.Panel_Back = Panel_Back;
	return self;
end;
function panel_backEvent:readStream(streamId, connection)
	self.object = NetworkUtil.readNodeObject(streamId);
	self.Panel_Back = streamReadBool(streamId);
	self:run(connection);
end;
function panel_backEvent:writeStream(streamId, connection)
	NetworkUtil.writeNodeObject(streamId, self.object);
	streamWriteBool(streamId, self.Panel_Back);
end;
function panel_backEvent:run(connection)
	if not connection:getIsServer() then
		g_server:broadcastEvent(self, false, connection, self.object);
	end;
	if self.object ~= nil then
		self.object:panel_back(self.Panel_Back, true);
	end;
end;
function panel_backEvent.sendEvent(vehicle, Panel_Back, noEventSend)
	if Panel_Back ~= vehicle.Panel_Back then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(panel_backEvent:new(vehicle, Panel_Back), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(panel_backEvent:new(vehicle, Panel_Back));
			end;
		end;
	end;
end;

panel_leftEvent = {};
panel_leftEvent_mt = Class(panel_leftEvent, Event);
InitEventClass(panel_leftEvent, "panel_leftEvent");

function panel_leftEvent:emptyNew()
    local self = Event:new(panel_leftEvent_mt);
    return self;
end;
function panel_leftEvent:new(object, Panel_Left)
	local self = panel_leftEvent:emptyNew()
	self.object = object;
	self.Panel_Left = Panel_Left;
	return self;
end;
function panel_leftEvent:readStream(streamId, connection)
	self.object = NetworkUtil.readNodeObject(streamId);
	self.Panel_Left = streamReadBool(streamId);
	self:run(connection);
end;
function panel_leftEvent:writeStream(streamId, connection)
	NetworkUtil.writeNodeObject(streamId, self.object);
	streamWriteBool(streamId, self.Panel_Left);
end;
function panel_leftEvent:run(connection)
	if not connection:getIsServer() then
		g_server:broadcastEvent(self, false, connection, self.object);
	end;
	if self.object ~= nil then
		self.object:panel_left(self.Panel_Left, true);
	end;
end;
function panel_leftEvent.sendEvent(vehicle, Panel_Left, noEventSend)
	if Panel_Left ~= vehicle.Panel_Left then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(panel_leftEvent:new(vehicle, Panel_Left), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(panel_leftEvent:new(vehicle, Panel_Left));
			end;
		end;
	end;
end;


panel_rightEvent = {};
panel_rightEvent_mt = Class(panel_rightEvent, Event);
InitEventClass(panel_rightEvent, "panel_rightEvent");

function panel_rightEvent:emptyNew()
    local self = Event:new(panel_rightEvent_mt);
    return self;
end;
function panel_rightEvent:new(object, Panel_Right)
	local self = panel_rightEvent:emptyNew()
	self.object = object;
	self.Panel_Right = Panel_Right;
	return self;
end;
function panel_rightEvent:readStream(streamId, connection)
	self.object = NetworkUtil.readNodeObject(streamId);
	self.Panel_Right = streamReadBool(streamId);
	self:run(connection);
end;
function panel_rightEvent:writeStream(streamId, connection)
	NetworkUtil.writeNodeObject(streamId, self.object);
	streamWriteBool(streamId, self.Panel_Right);
end;
function panel_rightEvent:run(connection)
	if not connection:getIsServer() then
		g_server:broadcastEvent(self, false, connection, self.object);
	end;
	if self.object ~= nil then
		self.object:panel_right(self.Panel_Right, true);
	end;
end;
function panel_rightEvent.sendEvent(vehicle, Panel_Right, noEventSend)
	if Panel_Right ~= vehicle.Panel_Right then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(panel_rightEvent:new(vehicle, Panel_Right), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(panel_rightEvent:new(vehicle, Panel_Right));
			end;
		end;
	end;
end;